/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.fabrictailor.mixin;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.InsecureTextureException;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import net.minecraft.class_1293;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2703;
import net.minecraft.class_2724;
import net.minecraft.class_2748;
import net.minecraft.class_2749;
import net.minecraft.class_2783;
import net.minecraft.class_2803;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3898;
import net.minecraft.class_4543;
import net.minecraft.class_6880;
import org.samo_lego.fabrictailor.FabricTailor;
import org.samo_lego.fabrictailor.casts.TailoredPlayer;
import org.samo_lego.fabrictailor.mixin.accessors.ChunkMapAccessor;
import org.samo_lego.fabrictailor.mixin.accessors.PlayerEntityAccessor;
import org.samo_lego.fabrictailor.mixin.accessors.TrackedEntityAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public class ServerPlayerEntityMixin_TailoredPlayer
implements TailoredPlayer {
    private final class_3222 player = (class_3222)this;
    private final GameProfile gameProfile = this.player.method_7334();
    private String skinValue;
    private String skinSignature;
    private final PropertyMap map = this.gameProfile.getProperties();
    private long lastSkinChangeTime = 0L;

    @Override
    public void reloadSkin() {
        if (this.player.method_5682() == null) {
            return;
        }
        class_3324 playerManager = this.player.method_5682().method_3760();
        playerManager.method_14581((class_2596)new class_2703(class_2703.class_5893.field_29140, new class_3222[]{this.player}));
        playerManager.method_14581((class_2596)new class_2703(class_2703.class_5893.field_29136, new class_3222[]{this.player}));
        class_3215 manager = this.player.method_14220().method_14178();
        class_3898 storage = manager.field_17254;
        TrackedEntityAccessor trackerEntry = (TrackedEntityAccessor)((ChunkMapAccessor)storage).getEntityTrackers().get(this.player.method_5628());
        trackerEntry.getSeenBy().forEach(tracking -> trackerEntry.getServerEntity().method_18760(tracking.method_32311()));
        class_3218 targetWorld = this.player.method_14220();
        this.player.field_13987.method_14364((class_2596)new class_2724(class_6880.method_40223((Object)targetWorld.method_8597()), targetWorld.method_27983(), class_4543.method_27984((long)targetWorld.method_8412()), this.player.field_13974.method_14257(), this.player.field_13974.method_30119(), targetWorld.method_27982(), targetWorld.method_28125(), true));
        this.player.field_13987.method_14363(this.player.method_23317(), this.player.method_23318(), this.player.method_23321(), this.player.method_36454(), this.player.method_36455());
        this.player.field_13995.method_3760().method_14576(this.player);
        this.player.field_13987.method_14364((class_2596)new class_2748(this.player.field_7510, this.player.field_7495, this.player.field_7520));
        this.player.field_13987.method_14364((class_2596)new class_2749(this.player.method_6032(), this.player.method_7344().method_7586(), this.player.method_7344().method_7589()));
        for (class_1293 statusEffect : this.player.method_6026()) {
            this.player.field_13987.method_14364((class_2596)new class_2783(this.player.method_5628(), statusEffect));
        }
        this.player.method_7355();
        playerManager.method_14606(this.player, targetWorld);
        playerManager.method_14594(this.player);
    }

    @Override
    public void setSkin(Property skinData, boolean reload) {
        try {
            this.map.removeAll((Object)"textures");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.map.put((Object)"textures", (Object)skinData);
            this.skinValue = skinData.getValue();
            this.skinSignature = skinData.getSignature();
            if (reload) {
                this.reloadSkin();
            }
            this.lastSkinChangeTime = System.currentTimeMillis();
        }
        catch (InsecureTextureException insecureTextureException) {
        }
        catch (Error e) {
            FabricTailor.errorLog(e.getMessage());
        }
    }

    @Override
    public void setSkin(String value, String signature, boolean reload) {
        this.setSkin(new Property("textures", value, signature), reload);
    }

    @Override
    public String getSkinValue() {
        if (this.skinValue == null) {
            try {
                Property property = (Property)this.map.get((Object)"textures").iterator().next();
                this.skinValue = property.getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.skinValue;
    }

    @Override
    public String getSkinSignature() {
        if (this.skinSignature == null) {
            try {
                Property property = (Property)this.map.get((Object)"textures").iterator().next();
                this.skinSignature = property.getSignature();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.skinSignature;
    }

    @Override
    public long getLastSkinChange() {
        return this.lastSkinChangeTime;
    }

    @Override
    public void clearSkin() {
        try {
            this.map.removeAll((Object)"textures");
            this.skinValue = null;
            this.skinSignature = null;
            this.reloadSkin();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void resetLastSkinChange() {
        this.lastSkinChangeTime = 0L;
    }

    @Inject(method={"updateOptions"}, at={@At(value="TAIL")})
    private void disableCapeIfNeeded(class_2803 packet, CallbackInfo ci) {
        if (!FabricTailor.config.allowCapes) {
            byte playerModel = (byte)packet.comp_270();
            playerModel = (byte)(playerModel & 0xFFFFFFFE);
            this.player.method_5841().method_12778(PlayerEntityAccessor.getPLAYER_MODEL_PARTS(), (Object)playerModel);
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void writeCustomDataToNbt(class_2487 tag, CallbackInfo ci) {
        if (this.getSkinValue() != null && this.getSkinSignature() != null) {
            class_2487 skinDataTag = new class_2487();
            skinDataTag.method_10582("value", this.getSkinValue());
            skinDataTag.method_10582("signature", this.getSkinSignature());
            tag.method_10566("fabrictailor:skin_data", (class_2520)skinDataTag);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readCustomDataFromNbt(class_2487 tag, CallbackInfo ci) {
        class_2487 skinDataTag = tag.method_10562("fabrictailor:skin_data");
        if (skinDataTag != null) {
            this.skinValue = skinDataTag.method_10545("value") ? skinDataTag.method_10558("value") : null;
            String string = this.skinSignature = skinDataTag.method_10545("signature") ? skinDataTag.method_10558("signature") : null;
            if (this.skinValue != null && this.skinSignature != null) {
                this.setSkin(this.skinValue, this.skinSignature, false);
            }
        }
    }
}

